<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="COCT_MT050000NL" see="http://wiki.hl7.org/index.php?title=Implementatiehandleiding_HL7v3_basiscomponenten_v2.2_Part3#CMET_R_PatientNLInformatiemodel">
    <title>R_PatientNL universal</title>
    <rule context="$element">
        <assert role="error" test="not(@classCode) or @classCode='PAT'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#PAT"
            >COCT_MT050000NL: @classCode moet indien aanwezig 'PAT' zijn</assert>
        <assert role="error" test="hl7:id[@root='2.16.840.1.113883.2.4.6.3']"
            >COCT_MT050000NL: er moet tenminste een burgerservicenummer zijn ter identificatie</assert>
    </rule>
    <rule context="$element/hl7:id">
        <extends rule="II"/>
    <assert role="error" test="not(@nullFlavor)"
            >COCT_MT050000NL: id is mandatory en mag geen @nullFlavor hebben</assert>
    </rule>
    <rule context="$element/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    <rule context="$element/hl7:confidentialityCode">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSystem) or @codeSystem='2.16.840.1.113883.5.25'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/Confidentiality.htm"
            >COCT_MT05000NL: vertrouwelijkheidscode moet komen uit codesysteem '2.16.840.1.113883.5.25'</assert>
    </rule>
    <rule context="$element/hl7:veryImportantPersonCode">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSystem) or @codeSystem='2.16.840.1.113883.5.1075'"
            >COCT_MT050000NL: VIP-code moet komen uit codesysteem '2.16.840.1.113883.5.1075'</assert>
    </rule>
    
    <title>E_PersonNL universal</title>
    <rule context="$element/hl7:Person">
        <assert role="error" test="not(@classCode) or @classCode='PSN'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#PSN"
            >COCT_MT050000NL/COCT_MT030200NL: @classCode moet indien aanwezig 'PSN' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'"  see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityDeterminer.htm#INSTANCE"
            >COCT_MT050000NL/COCT_MT030200NL: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>
        <assert role="error" test="not(hl7:id) or count(hl7:id)=1"
            >COCT_MT050000NL/COCT_MT030200NL: er kan slechts 1 persoonsnummer zijn</assert>
        <assert role="error" test="count(hl7:name) &lt;=2"
            >COCT_MT050000NL/COCT_MT030200NL: er mogen niet meer dan 2 persoonsnamen zijn</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.840.1.113883.2.4.6.3'"
            >COCT_MT050000NL/COCT_MT030200NL: als er een persoonsnummer wordt gebruikt moet dat het burgerservicenummer zijn</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:name">
        <extends rule="PN"/>
    </rule>
    <rule context="$element/hl7:Person/hl7:administrativeGenderCode">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSystem) or @codeSystem='2.16.840.1.113883.5.1'"
            >COCT_MT050000NL/COCT_MT030200NL: geslacht moet komen uit codesysteem '2.16.840.1.113883.5.1'</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:birthTime">
        <extends rule="TS"/>
    </rule>
    <rule context="$element/hl7:Person/hl7:deceasedInd">
        <extends rule="BL"/>
    </rule>
    <rule context="$element/hl7:Person/hl7:deceasedTime">
        <extends rule="TS"/>
    </rule>
    <rule context="$element/hl7:Person/hl7:multipleBirthInd">
        <extends rule="BL"/>
    </rule>
    <rule context="$element/hl7:Person/hl7:multipleBirthOrderNumber">
        <extends rule="INT"/>
    </rule>
    <rule context="$element/hl7:Person/hl7:maritalStatusCode">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSystem) or @codeSystem='2.16.840.1.113883.5.2'"
            >COCT_MT050000NL/COCT_MT030200NL: burgerlijke staat moet komen uit codesysteem '2.16.840.1.113883.5.2'</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:educationLevelCode">
        <extends rule="CE"/>
    </rule>
    
    <title>birthPlace</title>
    <rule context="$element/hl7:Person/hl7:birthPlace">
        <assert role="error" test="not(@classCode) or @classCode='BIRTHPLC'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#BIRTHPLC"
            >COCT_MT050000NL/COCT_MT030200NL: @classCode moet indien aanwezig 'BIRTHPLC' zijn</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:birthPlace/hl7:addr">
        <extends rule="AD"/>
        <assert role="error" test="@nullFlavor or hl7:city or hl7:county or hl7:country"
            >COCT_MT050000NL/COCT_MT030200NL: geboorteplaats moet tenminste het element city (plaats), county (gemeente), of country (land) bevatten</assert>
    </rule>
    
    <title>scopedContactParty</title>
    <rule context="$element/hl7:Person/hl7:scopedContactParty">
        <!--assert test="not(@classCode) or @classCode='CON'"
            >COCT_MT050000NL/COCT_MT030200NL: @classCode moet indien aanwezig 'CON' zijn</assert-->
    </rule>
    <rule context="$element/hl7:Person/hl7:scopedContactParty/hl7:code">
        <extends rule="CE"/>
        <assert role="error" test="@nullFlavor or @codeSystem='2.16.840.1.113883.5.111'"
            >COCT_MT050000NL/COCT_MT030200NL: contactpersoon code moet komen uit codesysteem '2.16.840.1.113883.5.111'</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:scopedContactParty/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:Person/hl7:scopedContactParty/hl7:Person">
        <assert role="error" test="not(@classCode) or @classCode='PSN'"
            >COCT_MT050000NL/COCT_MT030200NL: @classCode moet indien aanwezig 'PSN' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'"
            >COCT_MT050000NL/COCT_MT030200NL: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:scopedContactParty/hl7:Person/hl7:name">
        <extends rule="PN"/>
    </rule>
    
    <title>employment</title>
    <rule context="$element/hl7:Person/hl7:employment">
        <assert role="error" test="not(@classCode) or @classCode='EMP'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#EMP"
            >COCT_MT050000NL/COCT_MT030200NL: @classCode moet indien aanwezig 'EMP' zijn</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:employment/hl7:occupationCode">
        <extends rule="CE"/>
        <assert role="error" test="@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.30.11'"
            >COCT_MT050000NL/COCT_MT030200NL: contactpersoon code moet komen uit codesysteem '2.16.840.1.113883.2.4.4.30.11' (NHG Tabel 11)</assert>
    </rule>
    
    <title>playedPatientOfOtherProvider</title>
    <rule context="$element/hl7:Person/hl7:playedPatientOfOtherProvider">
        <assert role="error" test="not(@classCode) or @classCode='PAT'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#PAT"
            >COCT_MT050000NL/COCT_MT030200NL: @classCode moet indien aanwezig 'PAT' zijn</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:playedPatientOfOtherProvider/hl7:subjectOf">
        <assert role="error" test="not(@typeCode) or @typeCode='SBJ'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ParticipationType.htm#SBJ"
            >COCT_MT050000NL/COCT_MT030200NL: @typeCode moet indien aanwezig 'SBJ' zijn</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:playedPatientOfOtherProvider/hl7:subjectOf/hl7:patientCareProvision">
        <assert role="error" test="not(@classCode) or @classCode='PCPR'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActCode.htm#PCPR"
            >COCT_MT050000NL/COCT_MT030200NL: @classCode moet indien aanwezig 'PCPR' zijn</assert>
        <assert role="error" test="not(@moodCode) or @moodCode='EVN'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActMood.htm#EVN"
            >COCT_MT050000NL/COCT_MT030200NL: @moodCode moet indien aanwezig 'EVN' zijn</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:playedPatientOfOtherProvider/hl7:subjectOf/hl7:patientCareProvision/hl7:code">
        <extends rule="CE"/>
        <assert role="error" test="@nullFlavor or @codeSystem='2.16.840.1.113883.5.4'"
            >COCT_MT050000NL/COCT_MT030200NL: code moet komen uit codesysteem '2.16.840.1.113883.5.4'</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:playedPatientOfOtherProvider/hl7:subjectOf/hl7:patientCareProvision/hl7:responsibleParty">
        <assert role="error" test="not(@typeCode) or @typeCode='RESP'"
            >COCT_MT050000NL/COCT_MT030200NL: @typeCode moet indien aanwezig 'RESP' zijn</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:playedPatientOfOtherProvider/hl7:subjectOf/hl7:patientCareProvision/hl7:responsibleParty/hl7:healthCareProvider">
        <assert role="error" test="not(@classCode) or @classCode='PROV'"
            >COCT_MT050000NL/COCT_MT030200NL: @classCode moet indien aanwezig 'PROV' zijn</assert>
    </rule>
    <rule context="$element/hl7:Person/hl7:playedPatientOfOtherProvider/hl7:subjectOf/hl7:patientCareProvision/hl7:responsibleParty/hl7:healthCareProvider/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:Person/hl7:playedPatientOfOtherProvider/hl7:subjectOf/hl7:patientCareProvision/hl7:responsibleParty/hl7:healthCareProvider/hl7:healthCareChoice/hl7:healthCareProviderPerson">
        <assert role="error" test="not(@classCode) or @classCode='PSN'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#PSN"
            >COCT_MT050000NL/COCT_MT030200NL: @classCode moet indien aanwezig 'PSN' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityDeterminer.htm#INSTANCE"
            >COCT_MT050000NL/COCT_MT030200NL: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>        
    </rule>
    <rule context="$element/hl7:Person/hl7:playedPatientOfOtherProvider/hl7:subjectOf/hl7:patientCareProvision/hl7:responsibleParty/hl7:healthCareProvider/hl7:healthCareChoice/hl7:healthCareProviderPerson/hl7:name">
        <extends rule="PN"/>
    </rule>
    
    <title>COCT_MT1500001 E_Organization identified</title>
    <rule context="$element/hl7:Organization">
        <assert role="error" test="not(@classCode) or @classCode='ORG'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#ORG"
            >COCT_MT050000NL/COCT_MT150001NL: @classCode moet indien aanwezig 'ORG' zijn</assert>
        <assert role="error" test="hl7:id[@root='2.16.528.1.1007.3.3']"
            >COCT_MT050000NL/COCT_MT150001NL: er moet tenminste een UZI-registerabonneenummer zijn ter identificatie</assert>
    </rule>
    <rule context="$element/hl7:Organization/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:code">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSystem) or @codeSystem='2.16.840.1.113883.2.4.15.1060'"
            >COCT_MT050000NL/COCT_MT150001NL: organisatietype moet komen uit codesysteem '2.16.840.1.113883.2.4.15.1060'</assert>
    </rule>
    
</pattern>